#version 330 compatibility

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////











const int 		shadowMapResolution 	= 4096;
const float 	shadowDistance 			= 120.0; // Shadow distance. Set lower if you prefer nicer close shadows. Set higher if you prefer nicer distant shadows. [80.0 120.0 180.0 240.0]
const float 	shadowIntervalSize 		= 1.0f;
const bool 		shadowHardwareFiltering0 = true;

const bool 		shadowtexMipmap = true;
const bool 		shadowtex1Mipmap = false;
const bool 		shadowtex1Nearest = false;
const bool 		shadowcolor0Mipmap = false;
const bool 		shadowcolor0Nearest = false;
const bool 		shadowcolor1Mipmap = false;
const bool 		shadowcolor1Nearest = false;

const float shadowDistanceRenderMul = 1.0f;

const int 		RGB8 					= 0;
const int 		RGBA8 					= 0;
const int 		RGBA16 					= 0;
const int 		RGBA16F 				= 0;
const int 		RGBA32F 				= 0;
const int 		RG16 					= 0;
const int 		RGB16 					= 0;
const int 		R11F_G11F_B10F 			= 0;
const int 		colortex0Format 			= RGB8;
const int 		colortex1Format 			= RGBA16;
const int 		colortex2Format 			= RGBA16;
const int 		colortex3Format 			= RGBA16;
const int 		colortex4Format 			= RGBA16F;
const int 		colortex5Format 			= RGBA32F;
const int 		colortex6Format 			= RGBA16F;
const int 		colortex7Format 			= RGBA16;


const int 		superSamplingLevel 		= 0;

const float		sunPathRotation 		= -40.0f;

const int 		noiseTextureResolution  = 64;

const float 	ambientOcclusionLevel 	= 0.06f;


const bool colortex7Clear = false;

const float wetnessHalflife = 100.0;
const float drynessHalflife = 100.0;




in vec4 texcoord;

in vec3 lightVector;
in vec3 worldLightVector;
in vec3 worldSunVector;

in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSkyUp;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;









#include "lib/Uniforms.inc"
#include "lib/Common.inc"
#include "lib/Materials.inc"



/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// vec4 GetViewPosition(in vec2 coord, in float depth) 
// {	
// 	vec2 tcoord = coord;
// 	TemporalJitterProjPosInv01(tcoord);

// 	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
// 		 fragposition /= fragposition.w;

	
// 	return fragposition;
// }




/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include "lib/GBufferData.inc"




struct Ray {
	vec3 dir;
	vec3 origin;
};

struct Plane {
	vec3 normal;
	vec3 origin;
};

struct Intersection {
	vec3 pos;
	float distance;
	float angle;
};

/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////





Intersection 	RayPlaneIntersectionWorld(in Ray ray, in Plane plane)
{
	float rayPlaneAngle = dot(ray.dir, plane.normal);

	float planeRayDist = 100000000.0f;
	vec3 intersectionPos = ray.dir * planeRayDist;

	if (rayPlaneAngle > 0.0001f || rayPlaneAngle < -0.0001f)
	{
		planeRayDist = dot((plane.origin), plane.normal) / rayPlaneAngle;
		intersectionPos = ray.dir * planeRayDist;
		intersectionPos = -intersectionPos;

		intersectionPos += cameraPosition.xyz;
	}

	Intersection i;

	i.pos = intersectionPos;
	i.distance = planeRayDist;
	i.angle = rayPlaneAngle;

	return i;
}

Intersection 	RayPlaneIntersection(in Ray ray, in Plane plane)
{
	float rayPlaneAngle = dot(ray.dir, plane.normal);

	float planeRayDist = 100000000.0f;
	vec3 intersectionPos = ray.dir * planeRayDist;

	if (rayPlaneAngle > 0.0001f || rayPlaneAngle < -0.0001f)
	{
		planeRayDist = dot((plane.origin - ray.origin), plane.normal) / rayPlaneAngle;
		intersectionPos = ray.origin + ray.dir * planeRayDist;
		// intersectionPos = -intersectionPos;

		// intersectionPos += cameraPosition.xyz;
	}

	Intersection i;

	i.pos = intersectionPos;
	i.distance = planeRayDist;
	i.angle = rayPlaneAngle;

	return i;
}








vec3 CalculateSunlightVisibility(vec4 screenSpacePosition, MaterialMask mask) {				//Calculates shadows
	if (rainStrength >= 0.99f)
		return vec3(1.0f);



	//if (shadingStruct.direct > 0.0f) {
		float distance = sqrt(  screenSpacePosition.x * screenSpacePosition.x 	//Get surface distance in meters
							  + screenSpacePosition.y * screenSpacePosition.y
							  + screenSpacePosition.z * screenSpacePosition.z);

		vec4 ssp = screenSpacePosition;

		// if (isEyeInWater > 0.5)
		// {
		// 	ssp.xy *= 0.82;
		// }

		vec3 worldPos = (gbufferModelViewInverse * ssp).xyz;


		float dist;
		float distortFactor;
		vec3 shadowProjPos = WorldPosToShadowProjPos(worldPos.xyz, dist, distortFactor);

		// float fademult = 0.15f;
			// shadowMult = clamp((shadowDistance * 1.4f * fademult) - (distance * fademult), 0.0f, 1.0f);	//Calculate shadowMult to fade shadows out

		float shadowMult = 1.0;

		float shading = 0.0;
		vec3 result = vec3(0.0);

		if (shadowMult > 0.0) 
		{

			float diffthresh = dist * 1.0f + 0.10f;
				  diffthresh *= 2.0f / (shadowMapResolution / 2048.0f);
				  //diffthresh /= shadingStruct.direct + 0.1f;






			float vpsSpread = 0.105 / distortFactor;

			float avgDepth = 0.0;
			float minDepth = 11.0;
			int c;

			for (int i = -1; i <= 1; i++)
			{
				for (int j = -1; j <= 1; j++)
				{
					vec2 lookupCoord = shadowProjPos.xy + (vec2(i, j) / shadowMapResolution) * 8.0 * vpsSpread;
					//avgDepth += pow(texture2DLod(shadowtex1, lookupCoord, 2).x, 4.1);
					float depthSample = texture2DLod(shadowtex1, lookupCoord, 2).x;
					minDepth = min(minDepth, depthSample);
					avgDepth += pow(min(max(0.0, shadowProjPos.z - depthSample) * 1.0, 0.025), 2.0);
					c++;
				}
			}

			avgDepth /= c;
			avgDepth = pow(avgDepth, 1.0 / 2.0);

			// float penumbraSize = min(abs(shadowProjPos.z - minDepth), 0.15);
			float penumbraSize = avgDepth;

			//if (mask.leaves > 0.5)
			//{
				//penumbraSize = 0.02;
			//}

			int count = 0;
			float spread = penumbraSize * 0.055 * vpsSpread + 0.55 / shadowMapResolution;


			vec3 noise = BlueNoiseTemporal(texcoord.st);

			diffthresh *= 0.5 + avgDepth * 50.0;

			for (float i = -2.0f; i <= 2.0f; i += 1.0f) 
			{
				for (float j = -2.0f; j <= 2.0f; j += 1.0f) 
				{
					float angle = noise.x * 3.14159 * 2.0;

					mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

					vec2 coord = vec2(i, j) * rot;

					shading += shadow2DLod(shadowtex0, vec3(shadowProjPos.st + coord * spread, shadowProjPos.z - 0.0012f * diffthresh - (noise.z * 0.0001)), 0).x;
					count += 1;
				}
			}
			shading /= count;

			result = vec3(shading);


			// stained glass shadow
			{
				float stainedGlassShadow = shadow2DLod(shadowtex0, vec3(shadowProjPos.st - vec2(0.5, 0.0), shadowProjPos.z - 0.0012 * diffthresh), 2).x;
				vec3 stainedGlassColor = texture2DLod(shadowcolor, vec2(shadowProjPos.st - vec2(0.5, 0.0)), 2).rgb;
				stainedGlassColor *= stainedGlassColor;
				result = mix(result, result * stainedGlassColor, vec3(1.0 - stainedGlassShadow));

				// result = mix(result, vec3(0.0), vec3(1.0 - stainedGlassShadow));
			}

			// CAUSTICS
			// water shadow (caustics)
			{
				float waterDepth = abs(texture2DLod(shadowcolor1, shadowProjPos.st - vec2(0.0, 0.5), 4).x * 256.0 - (worldPos.y + cameraPosition.y));

				// float caustics = GetCausticsDeferred(worldPos, waterDepth);
				vec3 caustics = vec3(0.0);
				caustics.r = GetCausticsDeferred(worldPos, 										worldLightVector, waterDepth);
				// caustics.g = GetCausticsDeferred(worldPos + vec3(0.003 * waterDepth, 0.0, 0.0), worldLightVector, waterDepth);
				// caustics.b = GetCausticsDeferred(worldPos + vec3(0.006 * waterDepth, 0.0, 0.0), worldLightVector, waterDepth);
				caustics.g = caustics.r;
				caustics.b = caustics.r;

				float waterShadow = shadow2DLod(shadowtex0, vec3(shadowProjPos.st - vec2(0.0, 0.5), shadowProjPos.z - 0.0012 * diffthresh), 4).x;
				result = mix(result, 
					// result * caustics * exp(-GetWaterAbsorption() * waterDepth), 
					result * caustics, 
					vec3(1.0 - waterShadow));
			}
		}



		result = mix(vec3(1.0), result, shadowMult);





		return result;
	//} else {
	//	return vec3(0.0f);
	//}
}


vec3 SubsurfaceScatteringSunlight(vec3 worldNormal, vec3 worldPos, vec3 albedo)
{
	vec4 shadowProjPos = shadowModelView * vec4(worldPos.xyz, 1.0);	//Transform from world space to shadow space
	shadowProjPos = shadowProjection * shadowProjPos;
	shadowProjPos /= shadowProjPos.w;

	float dist = sqrt(shadowProjPos.x * shadowProjPos.x + shadowProjPos.y * shadowProjPos.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	shadowProjPos.xy *= 0.95f / distortFactor;
	shadowProjPos.z = mix(shadowProjPos.z, 0.5, 0.8);
	shadowProjPos = shadowProjPos * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates

	//move to quadrant
	shadowProjPos.xy *= 0.5;
	shadowProjPos.xy += 0.5;

	float subsurfaceDepth = 0.0;
	float depthThresh = 0.0005;
	float weights = 0.0;

	vec2 dither = BlueNoiseTemporal(texcoord.st).xy - 0.5;

	for (int i = -1; i <= 1; i++)
	{
		for (int j = -1; j <= 1; j++)
		{
			vec2 coordOffset = vec2(i + dither.x, j + dither.y) * 0.001;
			subsurfaceDepth += max(0.0, (shadowProjPos.z - texture2DLod(shadowtex1, shadowProjPos.xy + coordOffset, 0).x) / depthThresh);
			weights += 1.0;
		}
	}

	subsurfaceDepth /= weights;

	// subsurfaceDepth = exp(-subsurfaceDepth * 10.0);

	vec3 subsurfaceColor = 1.0 - (normalize(albedo.rgb + 0.000001) * 0.3);
	// vec3 subsurfaceColor = 1.0 - (albedo.rgb * 0.5);
	// vec3 subsurfaceColor = 1.0 - (albedo.rgb * 0.8);
	// vec3 subsurfaceColor = 1.0 - vec3(0.7, 0.5, 0.1);
	vec3 sss = exp(-subsurfaceDepth * subsurfaceColor * 6.0) * (1.0 - subsurfaceColor);

	return sss * 24.0 * colorSunlight;
}


float ScreenSpaceShadow(vec3 origin, vec3 normal, MaterialMask mask)
{
	if (mask.sky > 0.5 || rainStrength >= 0.999)
	{
		return 1.0;
	}

	if (isEyeInWater > 0.5)
	{
		origin.xy /= 0.82;
	}

	vec3 viewDir = normalize(origin.xyz);


	float nearCutoff = 0.50;
	float traceBias = 0.015;


	//Prevent self-intersection issues
	float viewDirDiff = dot(fwidth(viewDir), vec3(0.333333));


	vec3 rayPos = origin;
	vec3 rayDir = lightVector * 0.01;
	rayDir *= viewDirDiff * 2000.001;
	rayDir *= -origin.z * 0.28 + nearCutoff;


	rayPos += rayDir * -origin.z * 0.000017 * traceBias;



	float randomness = rand(texcoord.st + sin(frameTimeCounter)).x;

	rayPos += rayDir * randomness;



	float zThickness = 0.025 * -origin.z;

	float shadow = 1.0;

	float numSamplesf = 64.0;
	//numSamplesf /= -origin.z * 0.125 + nearCutoff;

	int numSamples = int(numSamplesf);


	float shadowStrength = 0.9;

	if (mask.grass > 0.5)
	{
		shadowStrength = 0.6;
	}
	if (mask.leaves > 0.5)
	{
		shadowStrength = 0.4;
	}

	// shadowStrength = pow(shadowStrength, exp2(-length(origin) * 0.05));

	// vec3 prevRayProjPos = ProjectBack(rayPos);

	for (int i = 0; i < 6; i++)
	{
		float fi = float(i) / float(12);

		rayPos += rayDir;

		vec2 rayProjPos = ProjectBack(rayPos).xy;


		TemporalJitterProjPos01(rayProjPos);




		// vec2 pixelPos = floor(rayProjPos.xy * vec2(viewWidth, viewHeight));
		// vec2 pixelPosPrev = floor(prevRayProjPos.xy * vec2(viewWidth, viewHeight));
		// if (pixelPos.x == pixelPosPrev.x || pixelPos.y == pixelPosPrev.y)
		// {
		// 	continue;
		// }

		// prevRayProjPos = rayProjPos;

		/*
		float sampleDepth = GetDepthLinear(rayProjPos.xy);

		float depthDiff = -rayPos.z - sampleDepth;
		*/

		vec3 samplePos = GetViewPositionNoJitter(rayProjPos.xy, GetDepth(rayProjPos.xy)).xyz;

		float depthDiff = samplePos.z - rayPos.z - 0.02 * -origin.z * traceBias;

		if (depthDiff > 0.0 && depthDiff < zThickness)
		{
			shadow *= 1.0 - shadowStrength;
		}
	}

	return shadow;
}


float OrenNayar(vec3 normal, vec3 eyeDir, vec3 lightDir)
{
	const float PI = 3.14159;
	const float roughness = 0.55;

	// interpolating normals will change the length of the normal, so renormalize the normal.



	// normal = normalize(normal + surface.lightVector * pow(clamp(dot(eyeDir, surface.lightVector), 0.0, 1.0), 5.0) * 0.5);

	// normal = normalize(normal + eyeDir * clamp(dot(normal, eyeDir), 0.0f, 1.0f));

	// calculate intermediary values
	float NdotL = dot(normal, lightDir);
	float NdotV = dot(normal, eyeDir);

	float angleVN = acos(NdotV);
	float angleLN = acos(NdotL);

	float alpha = max(angleVN, angleLN);
	float beta = min(angleVN, angleLN);
	float gamma = dot(eyeDir - normal * dot(eyeDir, normal), lightDir - normal * dot(lightDir, normal));

	float roughnessSquared = roughness * roughness;

	// calculate A and B
	float A = 1.0 - 0.5 * (roughnessSquared / (roughnessSquared + 0.57));

	float B = 0.45 * (roughnessSquared / (roughnessSquared + 0.09));

	float C = sin(alpha) * tan(beta);

	// put it all together
	float L1 = max(0.0, NdotL) * (A + B * max(0.0, gamma) * C);

	//return max(0.0f, surface.NdotL * 0.99f + 0.01f);
	return clamp(L1, 0.0f, 1.0f);
}





float GetCoverage(in float coverage, in float density, in float clouds)
{
	clouds = clamp(clouds - (1.0f - coverage), 0.0f, 1.0f -density) / (1.0f - density);
		clouds = max(0.0f, clouds * 1.1f - 0.1f);
	 clouds = clouds = clouds * clouds * (3.0f - 2.0f * clouds);
	 // clouds = pow(clouds, 1.0f);
	return clouds;
}

float   CalculateSunglow(vec3 npos, vec3 lightVector) {

	float curve = 4.0f;

	vec3 halfVector2 = normalize(-lightVector + npos);
	float factor = 1.0f - dot(halfVector2, npos);

	return factor * factor * factor * factor;
}

vec4 CloudColor(in vec4 worldPosition, in float sunglow, in vec3 worldLightVector, in float altitude, in float thickness, const bool isShadowPass)
{

	float cloudHeight = altitude;
	float cloudDepth  = thickness;
	float cloudUpperHeight = cloudHeight + (cloudDepth / 2.0f);
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);

	//worldPosition.xz /= 1.0f + max(0.0f, length(worldPosition.xz - cameraPosition.xz) / 5000.0f);

	vec3 p = worldPosition.xyz / 150.0f;



	float t = frameTimeCounter * 1.0f;
		  t *= 0.5;


	 p += (Get3DNoise(p * 2.0f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 0.10f;
	 p.z -= (Get3DNoise(p * 0.25f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 0.45f;
	 p.x -= (Get3DNoise(p * 0.125f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 2.2f;
	p.xz -= (Get3DNoise(p * 0.0525f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 2.7f;


	p.x *= 0.5f;
	p.x -= t * 0.01f;

	vec3 p1 = p * vec3(1.0f, 0.5f, 1.0f)  + vec3(0.0f, t * 0.01f, 0.0f);
	float noise  = 	Get3DNoise(p * vec3(1.0f, 0.5f, 1.0f) + vec3(0.0f, t * 0.01f, 0.0f));	p *= 2.0f;	p.x -= t * 0.057f;	vec3 p2 = p;
		  noise += (2.0f - abs(Get3DNoise(p) * 2.0f - 0.0f)) * (0.15f);						p *= 3.0f;	p.xz -= t * 0.035f;	p.x *= 2.0f;	vec3 p3 = p;
		  noise += (3.0f - abs(Get3DNoise(p) * 3.0f - 0.0f)) * (0.050f);						p *= 3.0f;	p.xz -= t * 0.035f;	vec3 p4 = p;
		  noise += (3.0f - abs(Get3DNoise(p) * 3.0f - 0.0f)) * (0.015f);						p *= 3.0f;	p.xz -= t * 0.035f;
		  if (!isShadowPass)
		  {
		 		noise += ((Get3DNoise(p))) * (0.022f);												p *= 3.0f;
		  		noise += ((Get3DNoise(p))) * (0.009f);
		  }
		  noise /= 1.475f;

	//cloud edge
	float coverage = 0.701f;
		  coverage = mix(coverage, 0.97f, rainStrength);

		  float dist = length(worldPosition.xz - cameraPosition.xz * 0.5);
		  coverage *= max(0.0f, 1.0f - dist / 14000.0f);
	float density = 0.1f + rainStrength * 0.3;

	if (isShadowPass)
	{
		return vec4(GetCoverage(0.4f, 0.4f, noise));
	}

	noise = GetCoverage(coverage, density, noise);

	const float lightOffset = 0.4f;



	float sundiff = Get3DNoise(p1 + worldLightVector.xyz * lightOffset);
		  sundiff += (2.0f - abs(Get3DNoise(p2 + worldLightVector.xyz * lightOffset / 2.0f) * 2.0f - 0.0f)) * (0.55f);
		  				float largeSundiff = sundiff;
		  				      largeSundiff = -GetCoverage(coverage, 0.0f, largeSundiff * 1.3f);
		  sundiff += (3.0f - abs(Get3DNoise(p3 + worldLightVector.xyz * lightOffset / 5.0f) * 3.0f - 0.0f)) * (0.045f);
		  sundiff += (3.0f - abs(Get3DNoise(p4 + worldLightVector.xyz * lightOffset / 8.0f) * 3.0f - 0.0f)) * (0.015f);
		  sundiff /= 1.5f;

		  sundiff *= max(0.0f, 1.0f - dist / 14000.0f);

		  sundiff = -GetCoverage(coverage * 1.0f, 0.0f, sundiff);
	float secondOrder 	= pow(clamp(sundiff * 1.1f + 1.45f, 0.0f, 1.0f), 4.0f);
	float firstOrder 	= pow(clamp(largeSundiff * 1.1f + 1.66f, 0.0f, 1.0f), 3.0f);



	float directLightFalloff = firstOrder * secondOrder;
	float anisoBackFactor = mix(clamp(pow(noise, 1.6f) * 2.5f, 0.0f, 1.0f), 1.0f, pow(sunglow, 1.0f));

		  directLightFalloff *= anisoBackFactor;
	 	  directLightFalloff *= mix(11.5f, 1.0f, pow(sunglow, 0.5f));

	//noise *= saturate(1.0 - directLightFalloff);

	vec3 colorDirect = colorSunlight * 51.215f;
		 colorDirect = mix(colorDirect, colorDirect * vec3(0.2f, 0.2f, 0.2f), timeMidnight);
		 colorDirect *= 1.0f + pow(sunglow, 2.0f) * 120.0f * pow(directLightFalloff, 1.1f) * (1.0 - rainStrength * 0.8);
		 colorDirect *= 1.0f;


	vec3 colorAmbient = mix(colorSkylight, colorSunlight * 2.0f, vec3(0.15f)) * 0.93f;
		 colorAmbient = mix(colorAmbient, vec3(0.4) * Luminance(colorSkylight), vec3(rainStrength));
		 colorAmbient *= mix(1.0f, 0.3f, timeMidnight);
		 colorAmbient = mix(colorAmbient, colorAmbient * 3.0f + colorSunlight * 0.05f, vec3(clamp(pow(1.0f - noise, 12.0f) * 1.0f, 0.0f, 1.0f)));




	directLightFalloff *= mix(1.0, 0.085, rainStrength);

	//directLightFalloff += (pow(Get3DNoise(p3), 2.0f) * 0.5f + pow(Get3DNoise(p3 * 1.5f), 2.0f) * 0.25f) * 0.02f;
	//directLightFalloff *= Get3DNoise(p2);

	vec3 color = mix(colorAmbient, colorDirect, vec3(min(1.0f, directLightFalloff)));

	color *= 1.0f;

	color = mix(color, color * 0.9, rainStrength);


	vec4 result = vec4(color.rgb, noise);

	return result;

}

void CloudPlane(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector)
{
	//Initialize view ray
	//vec4 worldVector = gbufferModelViewInverse * (vec4(-GetScreenSpacePosition(texcoord.st).xyz, 0.0));


	Ray viewRay;

	viewRay.dir = normalize(worldVector.xyz);
	viewRay.origin = vec3(0.0f);

	float sunglow = CalculateSunglow(viewDir, lightVector);



	float cloudsAltitude = 540.0f;
	float cloudsThickness = 150.0f;

	float cloudsUpperLimit = cloudsAltitude + cloudsThickness * 0.5f;
	float cloudsLowerLimit = cloudsAltitude - cloudsThickness * 0.5f;

	float density = 1.0f;

	float planeHeight = cloudsUpperLimit;
	float stepSize = 25.5f;
	planeHeight -= cloudsThickness * 0.85f;


	Plane pl;
	pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
	pl.normal = vec3(0.0f, 1.0f, 0.0f);

	Intersection i = RayPlaneIntersectionWorld(viewRay, pl);

	vec3 original = color.rgb;

	if (i.angle < 0.0f)
	{
		if (i.distance < linearDepth || mask.sky > 0.5 || linearDepth >= far - 0.1)
		{
			vec4 cloudSample = CloudColor(vec4(i.pos.xyz * 0.5f + vec3(30.0f) + vec3(1000.0, 0.0, 0.0), 1.0f), sunglow, worldLightVector, cloudsAltitude, cloudsThickness, false);
			 	 cloudSample.a = min(1.0f, cloudSample.a * density);


			float cloudDist = length(i.pos.xyz - cameraPosition.xyz);

			const vec3 absorption = vec3(0.2, 0.4, 1.0);

			cloudSample.rgb *= exp(-cloudDist * absorption * 0.0001 * saturate(1.0 - sunglow * 2.0) * (1.0 - rainStrength));

			cloudSample.a *= exp(-cloudDist * (0.0002 + rainStrength * 0.0009));


			//cloudSample.rgb *= sin(cloudDist * 0.3) * 0.5 + 0.5;

			color.rgb = mix(color.rgb, cloudSample.rgb * 1.0f, cloudSample.a);

		}
	}
}


float G1V(float dotNV, float k)
{
	return 1.0 / (dotNV * (1.0 - k) + k);
}

vec3 SpecularGGX(vec3 N, vec3 V, vec3 L, float roughness, float F0)
{
	float alpha = roughness * roughness;

	vec3 H = normalize(V + L);

	float dotNL = saturate(dot(N, L));
	float dotNV = saturate(dot(N, V));
	float dotNH = saturate(dot(N, H));
	float dotLH = saturate(dot(L, H));

	float F, D, vis;

	float alphaSqr = alpha * alpha;
	float pi = 3.14159265359;
	float denom = dotNH * dotNH * (alphaSqr - 1.0) + 1.0;
	D = alphaSqr / (pi * denom * denom);

	float dotLH5 = pow(1.0f - dotLH, 5.0);
	F = F0 + (1.0 - F0) * dotLH5;

	float k = alpha / 2.0;
	vis = G1V(dotNL, k) * G1V(dotNV, k);

	vec3 specular = vec3(dotNL * D * F * vis) * colorSunlight;

	//specular = vec3(0.1);
	#ifndef PHYSICALLY_BASED_MAX_ROUGHNESS
	specular *= saturate(pow(1.0 - roughness, 0.7) * 2.0);
	#endif


	return specular;
}




 int v(float v)
 {
   return int(floor(v));
 }
 int t(int f)
 {
   return f-v(mod(float(f),2.))-0;
 }
 int f(int f)
 {
   return f-v(mod(float(f),2.))-1;
 }
 int f()
 {
   ivec2 f=ivec2(viewWidth,viewHeight);
   int z=f.x*f.y;
   return t(v(floor(pow(float(z),.333333))));
 }
 int t()
 {
   ivec2 n=ivec2(2048,2048);
   int z=n.x*n.y;
   return f(v(floor(pow(float(z),.333333))));
 }
 vec3 d(vec2 v)
 {
   ivec2 n=ivec2(viewWidth,viewHeight);
   int z=n.x*n.y,y=f();
   ivec2 o=ivec2(v.x*n.x,v.y*n.y);
   float x=float(o.y/y),r=float(int(o.x+mod(n.x*x,y))/y);
   r+=floor(n.x*x/y);
   vec3 i=vec3(0.,0.,r);
   i.x=mod(o.x+mod(n.x*x,y),y);
   i.y=mod(o.y,y);
   i.xyz=floor(i.xyz);
   i/=y;
   i.xyz=i.xzy;
   return i;
 }
 vec2 r(vec3 n)
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int z=f();
   vec3 i=n.xzy*z;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 r;
   r.x=mod(i.x+x*z,v.x);
   float s=i.x+x*z;
   r.y=i.y+floor(s/v.x)*z;
   r+=.5;
   r/=v;
   return r;
 }
 vec3 e(vec2 f)
 {
   vec2 v=f;
   v.xy/=.5;
   ivec2 n=ivec2(2048,2048);
   int z=n.x*n.y,y=t();
   ivec2 i=ivec2(v.x*n.x,v.y*n.y);
   float x=float(i.y/y),r=float(int(i.x+mod(n.x*x,y))/y);
   r+=floor(n.x*x/y);
   vec3 o=vec3(0.,0.,r);
   o.x=mod(i.x+mod(n.x*x,y),y);
   o.y=mod(i.y,y);
   o.xyz=floor(o.xyz);
   o/=y;
   o.xyz=o.xzy;
   return o;
 }
 vec2 d(vec3 v,int z)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   ivec2 n=ivec2(2048,2048);
   vec3 i=v.xzy*z;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 f;
   f.x=mod(i.x+x*z,n.x);
   float s=i.x+x*z;
   f.y=i.y+floor(s/n.x)*z;
   f+=.5;
   f/=n;
   f.xy*=.5;
   return f;
 }
 vec3 e(vec3 v,int z)
 {
   return v*=1./z,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 f(vec3 v,int z)
 {
   return v*=1./z,v=v+vec3(.5),v;
 }
 vec3 m(vec3 v)
 {
   int f=t();
   v=v-vec3(.5);
   v*=f;
   return v;
 }
 vec3 s(vec3 v)
 {
   int z=f();
   v*=1./z;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 x(vec3 v)
 {
   int z=f();
   v=v-vec3(.5);
   v*=z;
   return v;
 }
 vec3 d()
 {
   vec3 v=cameraPosition.xyz+.5,i=previousCameraPosition.xyz+.5,z=floor(v-.0001),y=floor(i-.0001);
   return z-y;
 }
 vec3 n(vec3 v)
 {
   vec4 i=vec4(v,1.);
   i=shadowModelView*i;
   i=shadowProjection*i;
   i/=i.w;
   float x=sqrt(i.x*i.x+i.y*i.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   i.xy*=.95f/y;
   i.z=mix(i.z,.5,.8);
   i=i*.5f+.5f;
   i.xy*=.5;
   i.xy+=.5;
   return i.xyz;
 }
 vec3 d(vec3 v,vec3 i,vec3 z,vec3 f,int y)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 o=n(v);
   float x=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(o.xy,o.z-.0006*x),0).x;
   r*=saturate(dot(i,z));
   {
     vec4 s=texture2DLod(shadowcolor1,o.xy-vec2(0.,.5),4);
     float t=abs(s.x*256.-(v.y+cameraPosition.y)),w=GetCausticsComposite(v,i,t),h=shadow2DLod(shadowtex0,vec3(o.xy-vec2(0.,.5),o.z+1e-06),4).x;
     r=mix(r,r*w,1.-h);
   }
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }
 vec3 e(vec3 v,vec3 i,vec3 z,vec3 f,int y)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 x=m(v),o=n(x+z*.99);
   float r=.5;
   vec3 t=vec3(1.)*shadow2DLod(shadowtex0,vec3(o.xy,o.z-.0006*r),3).x;
   t*=saturate(dot(i,z));
   t=TintUnderwaterDepth(t);
   return t*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 i,vec3 z,vec3 f,int y)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 o=n(v);
   float x=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(o.xy,o.z-.0006*x),2).x;
   r*=saturate(dot(i,z));
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }struct GITemporalData2{float cNuyPQlxuC;float ZFucbkcOTp;float vfyvrzqkzI;float xSSGSkZnBe;vec3 MXlHQOttjo;};
 vec4 w(GITemporalData2 v)
 {
   vec4 i;
   v.MXlHQOttjo=max(vec3(0.),v.MXlHQOttjo);
   i.x=v.cNuyPQlxuC;
   v.MXlHQOttjo=pow(v.MXlHQOttjo,vec3(.25));
   i.y=PackTwo16BitTo32Bit(v.MXlHQOttjo.x,v.vfyvrzqkzI);
   i.z=PackTwo16BitTo32Bit(v.MXlHQOttjo.y,v.xSSGSkZnBe);
   i.w=PackTwo16BitTo32Bit(v.MXlHQOttjo.z,v.ZFucbkcOTp);
   return i;
 }
 GITemporalData2 h(vec4 v)
 {
   GITemporalData2 i;
   vec2 n=UnpackTwo16BitFrom32Bit(v.y),o=UnpackTwo16BitFrom32Bit(v.z),f=UnpackTwo16BitFrom32Bit(v.w);
   i.cNuyPQlxuC=v.x;
   i.vfyvrzqkzI=n.y;
   i.xSSGSkZnBe=o.y;
   i.ZFucbkcOTp=f.y;
   i.MXlHQOttjo=pow(vec3(n.x,o.x,f.x),vec3(4.));
   return i;
 }
 GITemporalData2 i(vec2 v)
 {
   vec2 z=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*z;
   return h(texture2DLod(colortex5,v,0));
 }
 float h(float v,float z)
 {
   float i=1.;
   #ifdef FULL_RT_REFLECTIONS
   i=clamp(pow(v,.125)+z,0.,1.);
   #else
   i=clamp(v*10.-7.,0.,1.);
   #endif
   return i;
 }
 void d(inout float v,inout float i,float z,float f,vec3 r,float y)
 {
   v*=mix(2.4,2.4,f);
   float x=dot(r,vec3(1.));
   i*=1.-pow(f,.4);
   i/=z*.1+2e-06;
   i*=4.;
   i*=.6;
   float o=z/(x+1e-07)*.2+4e-08;
   o=min(o,1.);
   o=mix(o,1.,pow(f,.25));
   if(y<.12)
     i=0.;
 }
 float d(vec3 v,vec3 z,float f)
 {
   float i=dot(abs(v-z),vec3(.3333));
   i*=f;
   i*=.18;
   return i;
 }
 void e(inout vec3 v,vec2 z,vec3 y)
 {}
 float i(float v,float z)
 {
   return v/(z*20.01+1.);
 }struct BBRay{vec3 origin;vec3 direction;vec3 inv_direction;ivec3 sign;};
 BBRay m(vec3 v,vec3 z)
 {
   vec3 i=vec3(1.)/z;
   return BBRay(v,z,i,ivec3(i.x<0?1:0,i.y<0?1:0,i.z<0?1:0));
 }
 void d(in BBRay v,in vec3 i[2],out float f,out float z)
 {
   float r,y,x,o;
   f=(i[v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   z=(i[1-v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   r=(i[v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   y=(i[1-v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   x=(i[v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   o=(i[1-v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   f=max(max(f,r),x);
   z=min(min(z,y),o);
 }
 vec3 p(vec3 v)
 {
   float i=fract(frameCounter*.0123456);
   int z=t(),y=f();
   vec3 x=BlueNoiseTemporal(texcoord.xy).xyz,o=BlueNoiseTemporal(texcoord.xy+.1).xyz,n=v,r=Fract01(cameraPosition.xyz+.5)+vec3(0.,1.7,0.),w=r;
   r=e(r,z);
   Ray s;
   s.origin=r*z-vec3(1.,1.,1.);
   s.dir=n;
   BBRay h=m(s.origin,s.dir);
   vec3 c=vec3(1.),p=vec3(0.);
   for(int B=0;B<1;B++)
     {
       vec3 F=vec3(floor(s.origin)),G=abs(vec3(length(s.dir))/(s.dir+.0001)),Y=sign(s.dir),l=(sign(s.dir)*(F-s.origin)+sign(s.dir)*.5+.5)*G,C;
       vec4 a=vec4(0.);
       vec3 g=vec3(0.);
       float S=.5;
       for(int M=0;M<190;M++)
         {
           g=F/float(z);
           vec2 I=d(g,z);
           a=texture2DLod(shadowcolor,I,0);
           if(abs(a.w*255.-130.)<.5)
             p+=.06125*c*colorTorchlight*S;
           else
             {
               if(a.w*255.<254.f&&M!=0)
                 {
                   break;
                 }
             }
           C=step(l.xyz,l.yzx)*step(l.xyz,l.zxy);
           l+=C*G;
           F+=C*Y;
           S=1.;
         }
       p+=a.xyz;
     }
   p*=1.;
   return p;
 }
 vec3 n(vec3 v,vec3 z)
 {
   v+=Fract01(cameraPosition.xyz+.5)-.5;
   vec3 f=s(v+z*.1),y=i(r(f)).MXlHQOttjo;
   return y;
 }
 vec3 e(vec2 v,vec3 z,float i,vec3 y)
 {
   vec3 f=texture2DLod(colortex6,v,0).xyz;
   return f;
 }
 void main()
 {
   GBufferData v=GetGBufferData();
   MaterialMask i=CalculateMasks(v.materialID);
   vec4 o=GetViewPosition(texcoord.xy,v.depth),y=gbufferModelViewInverse*vec4(o.xyz,1.),n=gbufferModelViewInverse*vec4(o.xyz,0.);
   vec3 z=normalize(o.xyz),f=normalize(n.xyz),r=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz);
   float x=length(o.xyz);
   vec3 s=vec3(0.);
   if(i.grass>.5)
     r=vec3(0.,1.,0.);
   vec3 m=e(texcoord.xy,v.normal,v.depth,o.xyz)*10.,t=m*v.albedo.xyz;
   const float h=75.;
   if(x>h)
     {
       vec3 c=FromSH(skySHR,skySHG,skySHB,r);
       c=mix(c,vec3(.2)*(dot(r,vec3(0.,1.,0.))*.35+.65)*Luminance(colorSkylight),vec3(rainStrength));
       c*=v.mcLightmap.y;
       vec3 w=c*v.albedo.xyz*2.5;
       const float G=3.7;
       w+=v.mcLightmap.x*colorTorchlight*v.albedo.xyz*.025*G;
       vec3 F=normalize(v.albedo.xyz+.0001)*pow(length(v.albedo.xyz),1.)*colorSunlight*.13*v.mcLightmap.y;
       w+=F*v.albedo.xyz*5.;
       float p=.3;
       t=mix(t,w,vec3(saturate(x*p-h*p)));
     }
   s.xyz=t;
   #ifdef HELD_LIGHT
   {
     float c=float(heldBlockLightValue+heldBlockLightValue2)/16.,w=OrenNayar(r,-f,-f),p=1./(dot(n.xyz,n.xyz)+.3);
     s+=v.albedo.xyz*c*p*w*colorTorchlight*.3;
   }
   #endif
   float c=24.*(1.-rainStrength),w=dot(r,worldLightVector),p=OrenNayar(r,-f,worldLightVector);
   if(i.leaves>.5)
     p=mix(p,.5,.5);
   if(i.grass>.5)
     v.metalness=0.;
   vec3 G=CalculateSunlightVisibility(o,i);
   #ifdef SUNLIGHT_LEAK_FIX
   float F=saturate(v.mcLightmap.y*100.);
   if(isEyeInWater<1)
     G*=F;
   #endif
   if(isEyeInWater<1)
     G*=ScreenSpaceShadow(o.xyz,v.normal.xyz,i);
   s+=TintUnderwaterDepth(DoNightEyeAtNight(p*v.albedo.xyz*G*c*colorSunlight,timeMidnight));
   vec3 B=SpecularGGX(r,-f,worldLightVector,1.-v.smoothness,v.metalness*.98+.02)*c*G;
   B*=mix(vec3(1.),v.albedo.xyz,vec3(v.metalness));
   if(isEyeInWater<.5)
     s*=1.-v.metalness,s+=DoNightEyeAtNight(B,timeMidnight);
   if(i.sky>.5||v.depth>1.)
     {
       vec3 l=f.xyz;
       if(isEyeInWater>0)
         l.xyz=refract(l.xyz,vec3(0.,-1.,0.),1.2533);
       s=SkyShading(l.xyz,worldSunVector.xyz,rainStrength);
       vec3 S=AtmosphereAbsorption(l.xyz);
       s+=v.albedo.xyz*S*.5;
       s+=RenderSunDisc(l,worldSunVector)*S*2000.*(1.-rainStrength);
       CloudPlane(s,z,-l,x,i,worldLightVector,lightVector);
     }
   if(i.glowstone>.5)
     s.xyz+=v.albedo.xyz*GI_LIGHT_BLOCK_INTENSITY;
   if(i.torch>.5)
     s.xyz+=v.albedo.xyz*pow(length(v.albedo.xyz),2.)*.5*GI_LIGHT_TORCH_INTENSITY;
   if(i.lava>.5)
     s+=v.albedo.xyz*.75*GI_LIGHT_BLOCK_INTENSITY;
   if(i.fire>.5)
     s+=v.albedo.xyz*3.*GI_LIGHT_TORCH_INTENSITY;
   float S=0.;
   s*=.001;
   s=LinearToGamma(s);
   s+=rand(texcoord.xy+sin(frameTimeCounter))*(1./65535.);
   gl_FragData[0]=vec4(s.xyz,1.);
 };




/* DRAWBUFFERS:3 */
